from fastapi import FastAPI, Request, Response
from fastapi.staticfiles import StaticFiles
from fastapi.templating import Jinja2Templates
from os.path import isfile
from mimetypes import guess_type

# class ConnectionManager:
#     def __init__(self):
#         self.active_connections: list[WebSocket] = []
    
#     async def connect(self, websocket: WebSocket):
#         await websocket.accept()
#         self.active_connections.append(websocket)

#     def disconnect(self, websocket: WebSocket):
#         self.active_connections.remove(websocket)

#     async def send_personal_message(self, message: dict, websocket: WebSocket):
#         await websocket.send_json(message)
    
#     async def broadcast(self, message: str):
#         for connection in self.active_connections:
#             await connection.send_json(message)

# manager = ConnectionManager()

app = FastAPI()

templates = Jinja2Templates(directory="./webapp")

app.mount("/", StaticFiles(directory="webapp", html=True), name="webapp")

# app.mount("/static", StaticFiles(directory="./webapp/assets"), 'assets')
# app.mount("/static", StaticFiles(directory="./webapp/canvaskit"), 'canvaskit')
# app.mount("/static", StaticFiles(directory="./webapp/icons"), 'icons')

@app.get("/")
async def serve_spa(request: Request):
    await get_site("index.html")
    #return templates.TemplateResponse(request=request, name="index.html")

@app.get("/{filename}")
async def get_site(filename):
    #filename = "./webapp/" + filename
    filename = "/" + filename
    if not isfile(filename):
        return Response(status_code=404)
    with open(filename) as f:
        content = f.read()
    content_type, _ = guess_type(filename)
    return Response(content, media_type=content_type)

# @app.websocket("/ws/{client_id}")
# async def websocket_endpoint(websocket: WebSocket, client_id: int):
#     await manager.connect(websocket)
#     try:
#         while True:
#             data = await websocket.receive_json()
#             await manager.send_personal_message(data, websocket)
#             await manager.broadcast(data)
#     except WebSocketDisconnect:
#         manager.disconnect(websocket)
#         await manager.broadcast(f"Client #{client_id} has left the chat")

# Route handler for other paths
# @app.get("/{reset_of_path:path}")
# async def react_app(req: Request, rest_of_path: str):
#     return templates.TemplateResponse('index.html', { 'request' : req})